package com.vmware.automatic.plugin.registration.resources;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

import java.util.ArrayList;
import java.util.List;

/**
 * A helper test class used to simulate user provided command line arguments
 */
public class CommandLineBuilder {

   private final Options options = new Options();
   private final List<String> cmdLineArgs = new ArrayList();

   public CommandLineBuilder key(String key) {
      options.addOption(
            Option.builder("k").longOpt("key").hasArg().argName("key")
                  .desc("Plugin key").required().build());
      cmdLineArgs.add("-k");
      cmdLineArgs.add(key);
      return this;
   }

   public CommandLineBuilder url(String url) {
      options.addOption(Option.builder("url").longOpt("vcenterUrl").hasArg()
            .argName("vc url").desc("vCenter server URL").required().build());
      cmdLineArgs.add("-url");
      cmdLineArgs.add(url);
      return this;
   }

   public CommandLineBuilder username(String username) {
      options.addOption(
            Option.builder("u").longOpt("username").hasArg().argName("vc user")
                  .desc("vCenter server username").required().build());
      cmdLineArgs.add("-u");
      cmdLineArgs.add(username);
      return this;
   }

   public CommandLineBuilder password(String password) {
      options.addOption(
            Option.builder("p").longOpt("password").hasArg().argName("vc pass")
                  .desc("vCenter server password").required().build());
      cmdLineArgs.add("-p");
      cmdLineArgs.add(password);
      return this;
   }

   public CommandLineBuilder version(String version) {
      options.addOption(
            Option.builder("v").longOpt("version").hasArg().argName("version")
                  .desc("Plugin version").build());
      cmdLineArgs.add("-v");
      cmdLineArgs.add(version);
      return this;
   }

   public CommandLineBuilder pluginUrl(String pluginUrl) {
      options.addOption(Option.builder("pu").longOpt("pluginUrl").hasArg()
            .argName("plugin url")
            .desc("Url from where the plugin will be downloaded").build());
      cmdLineArgs.add("-pu");
      cmdLineArgs.add(pluginUrl);
      return this;
   }

   public CommandLineBuilder label(String label) {
      options.addOption(
            Option.builder("n").longOpt("name").hasArg().argName("name")
                  .desc("Plugin name").required(false).build());
      cmdLineArgs.add("-n");
      cmdLineArgs.add(label);
      return this;
   }

   public CommandLineBuilder summary(String summary) {
      options.addOption(
            Option.builder("s").longOpt("summary").hasArg().argName("summary")
                  .desc("Plugin summary").required(false).build());
      cmdLineArgs.add("-s");
      cmdLineArgs.add(summary);
      return this;
   }

   public CommandLineBuilder company(String company) {
      options.addOption(
            Option.builder("c").longOpt("company").hasArg().argName("company")
                  .desc("Plugin company").required(false).build());
      cmdLineArgs.add("-c");
      cmdLineArgs.add(company);
      return this;
   }

   public CommandLineBuilder serverThumbprint(String serverThumbprint) {
      options.addOption(
            Option.builder("st").longOpt("serverThumbprint").hasArg()
                  .argName("server thumbprint")
                  .desc("Thumbprint of the server from which the plugin will be downloaded.")
                  .required(false).build());
      cmdLineArgs.add("-st");
      cmdLineArgs.add(serverThumbprint);
      return this;
   }

   public CommandLineBuilder showInSolutionManager(
         boolean showInSolutionManager) {
      options.addOption(Option.builder("show").longOpt("showInSolutionManager")
            .desc("If specified the plugin will be shown in Administration panel, Solutions plug-in list")
            .required(false).build());
      cmdLineArgs.add("-show");
      return this;
   }

   public CommandLineBuilder remote() {
      options.addOption("remote", false,
            "If specified will register/update a remote plugin");
      cmdLineArgs.add("-remote");
      return this;
   }

   public CommandLineBuilder local() {
      options.addOption("local", false,
            "If specified will register/update a local plugin");
      cmdLineArgs.add("-local");
      return this;
   }

   public CommandLineBuilder defaults() {
      return this.key("plugin-key").url("https://my-vcenter-server.com/sdk")
            .username("administrator@vsphere.local").password("Admin!23");
   }

   public CommandLine build() throws ParseException {
      return new DefaultParser()
            .parse(options, cmdLineArgs.toArray(new String[0]));
   }
}
